#!/bin/sh
emulator_path=$PWD/emulator
DIR=$PWD/arm64-v8a
export ANDROID_PRODUCT_OUT=$DIR
export ANDROID_BUILD_TOP=$DIR

cd $DIR
$emulator_path/emulator -system $DIR/system.img -data $DIR/userdata.img -ramdisk $DIR/ramdisk.img -kernel $DIR/kernel-ranchu -cache $DIR/cache.img -sysdir $DIR \
    -writable-system \
    -no-window  \
    -verbose \
    -show-kernel \
    -no-cache \
    -no-snapstorage \
    -no-snapshot-save \
    -no-snapshot-load \
    -no-audio \
    -no-snapshot \
    -wipe-data \
    -no-boot-anim \
    -dns-server 8.8.8.8 -netdelay none -no-sim \
    -accel on -qemu -smp 4 -m 4096 -no-reboot -s
    # -accel off -qemu -machine accel=tcg -cpu cortex-a53 -smp 4 -m 4096 -no-reboot -s
